@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')

{{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
{{--    <script src="https://unpkg.com/tableexport.jquery.plugin/tableExport.min.js"></script>--}}
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
{{--<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/js/tempusdominus-bootstrap-4.min.js"></script>--}}
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
{{--<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/css/tempusdominus-bootstrap-4.min.css" />--}}
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
{{--<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">--}}
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            /*width: 30%;*/
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }

        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }

        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 75vh !important;
        }
        .exampleSearch {
            width: 300px;
            height: 500px;
            margin: 0 auto;
            display: block;
            margin-top: 300px;
        }
</style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">

            {{-- 攝影機 選單區--}}
            <div class="collapse p-4 col-md-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                <a href="{{ Route("leave_index") }}" style="text-decoration:none;"><h2 class="text-dark" style="font-size: 20pt;text-align: center;background: white">差勤管理</h2></a>
                <div style="height: 5vh"></div>
                {{--空白分隔列--}}
                <div style="overflow: hidden">
                    <nav class="nav flex-column">
                        <a id="title_person" class="nav-link" data-toggle="collapse" href="#collapsePerson" role="button" aria-expanded="false" aria-controls="collapsePerson" href="#" style="color: #ffffff;display: none">人員管理</a>
                        <div class="collapse" id="collapsePerson">
                            <div class="card card-body" style="background: rgba(255,255,255,0);font-size:17px;">
                                <a id="1" class="nav-link" href="{{ Route("person") }}" style="color: #ffffff;display: none">人臉庫管理</a>
                                <a id="4" class="nav-link" href="{{ Route("comparison") }}" style="color: #ffffff;display: none">打卡紀錄</a>
                                <a id="5" class="nav-link" href="{{ Route("Group_index") }}" style="color: #ffffff;display: none">人員群組管理</a>
                                <a id="6" class="nav-link" href="{{ Route("insert_user") }}" style="color: #ffffff;display: none">使用者管理</a>
                            </div>
                        </div>
                        <a id="title_attendance" class="nav-link" data-toggle="collapse" href="#collapseLeave" role="button" aria-expanded="false" aria-controls="collapseLeave" href="#" style="color: #ffffff;display: none">差勤管理</a>
                        <div class="collapse show" id="collapseLeave">
                            <div class="card card-body" style="background: rgba(255,255,255,0);font-size:17px;">
                                <a id="7" class="nav-link" href="{{ Route("leave_index") }}" style="color: #ffffff;display: none">員工請假</a>
                                <a id="8" class="nav-link" href="{{ Route("businesstrip_index") }}" style="color: #ffffff;display: none">員工出差</a>
                                <a id="17" class="nav-link" href="{{ Route("overtime_index") }}" style="color: #ffffff;display: none">加班申請</a>
                                <a id="9" class="nav-link" href="{{ Route("checkleave_index") }}" style="color: #ffffff;background: rgba(255,255,255,0.2);display: none">請假審核</a>
                                <a id="23" class="nav-link" href="{{ Route("check_overtime") }}" style="color: #ffffff;display: none">加班審核</a>
                                <a id="22" class="nav-link" href="{{ Route("statistics_index") }}" style="color: #ffffff;display: none">請假統計</a>
                                <a id="10" class="nav-link" href="{{ Route("attendance") }}" style="color: #ffffff;display: none">出勤管理</a>
                                <a id="11" class="nav-link" href="{{ Route("graph_attendance") }}" style="color: #ffffff;display: none">差勤圖表</a>
                            </div>
                        </div>
                        <a id="title_device"class="nav-link" data-toggle="collapse" href="#collapseDevice" role="button" aria-expanded="false" aria-controls="collapseDevice" href="#" style="color: #ffffff;display: none">設備管理</a>
                        <div class="collapse " id="collapseDevice">
                            <div class="card card-body" style="background: rgba(255,255,255,0);font-size:17px;">
                                <a id="12" class="nav-link" href="{{ Route("device") }}" style="color: #ffffff;display: none">設備管理</a>
                                <a id="13" class="nav-link" href="{{ Route("type") }}" style="color: #ffffff;display: none">類型管理</a>
                                <a id="14" class="nav-link" href="{{ Route("group") }}" style="color: #ffffff;display: none">群組管理</a>
                                <a id="15" class="nav-link" href="{{ Route("relation") }}" style="color: #ffffff;display: none">設備群組關係</a>
                            </div>
                        </div>
                    </nav>
                    @foreach($authority as $auth)
                        <script>
                            var a_this=document.getElementById({{$auth["features_id"]}});
                            // device.style.visibility="visible";
                            a_this.style.display="";

                            if({{$auth["features_id"]}}=='1' || {{$auth["features_id"]}}=='4' || {{$auth["features_id"]}}=='5' || {{$auth["features_id"]}}=='6' )
                            {
                                var person=document.getElementById("title_person");
                                person.style.display="";
                            }
                            if({{$auth["features_id"]}}=='7' || {{$auth["features_id"]}}=='8' || {{$auth["features_id"]}}=='17' || {{$auth["features_id"]}}=='9' || {{$auth["features_id"]}}=='10' || {{$auth["features_id"]}}=='11'|| {{$auth["features_id"]}}=='22'|| {{$auth["features_id"]}}=='23' )
                            {
                                var attendance=document.getElementById("title_attendance");
                                attendance.style.display="";
                            }
                            if({{$auth["features_id"]}}=='12' || {{$auth["features_id"]}}=='13' || {{$auth["features_id"]}}=='14' || {{$auth["features_id"]}}=='15' )
                            {
                                var device=document.getElementById("title_device");
                                device.style.display="";
                            }
                        </script>
                    @endforeach


                </div>
                <form method="GET" action="{{ Route("user_logout") }}">
                    <div class="col-12" style="text-align: center">
                        <input class="btn btn-outline-light" style="font-size:16px;text-align: center" type="submit" id="logout" name="logout" value="登出" >
                    </div>
                </form>
            </div>
            {{--攝影機 畫面區--}}
            <div id="Screen-aria" class="col-md-10" style="background:#e0e6ec">
                {{--頁面選單--}}
{{--                <div id="menu" class="row" style="background: white">--}}
{{--                    <div class="col-6 text-center"><a href="{{ Route("leave_index") }}" style="text-decoration:none;color: #1b1e21;">員工請假管理</a></div>--}}
{{--                    <div class="col-6 text-center"><a href="{{ Route("checkleave_index") }}" style="text-decoration:none;color: #28a745;">主管審核</a></div>--}}
{{--                </div>--}}
                {{--保留區域--}}
                <div style="height: 5vh;width: 100%"></div>
                <div id="Screens" style="height: 85vh;width: 100%">
                    {{--操作列--}}
                    <div class="row" style="height: 10vh;align-items: center">
                        <div class="col-6" style="padding-right: 0px;">
{{--                            <form method="POST" action="{{ route('person_search_type') }}">--}}
{{--                            {{ csrf_field() }}--}}
{{--                            <div class="input-group">--}}
{{--                                <select name="search_type" class="custom-select" id="inputGroupSelect04">--}}
{{--                                    <option value="default" selected>請選擇類別</option>--}}
{{--                                    <option value="1">ID</option>--}}
{{--                                    <option value="2">姓名</option>--}}
{{--                                    <option value="3">類別</option>--}}
{{--                                </select>--}}
{{--                                <input name="search_text" type="text" class="form-control" placeholder="預搜尋內容" >--}}
{{--                                <div class="input-group-append">--}}
{{--                                    <button class="btn btn-dark" type="submit">搜尋</button>--}}
{{--                                </div>--}}
{{--                            </div>--}}
{{--                            </form>--}}
                        </div>
                        <div class="col-6 float-right">
{{--                            <form method="GET" action="{{ Route("sender_mail") }}">--}}
{{--                                <div class="col-12" style="text-align: center">--}}
{{--                                    <input  class="btn btn-outline-dark float-right" style="font-size:16px;text-align: center" type="submit" value="測試寄信" >--}}
{{--                                </div>--}}
{{--                            </form>--}}
{{--                            <button class="btn btn-outline-dark float-right" onclick="delete_face()">刪除全部</button>--}}
{{--                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;"  data-toggle="modal" onclick="window.location='{{url("checkleave/email")}}'">寄出信件</button>--}}
{{--                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;"  data-toggle="modal" onclick="location.href='{{ route("excel_example") }}'">批量匯入範例</button>--}}
{{--                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" onclick="post_delete_face()">批量刪除</button>--}}
{{--                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" data-toggle="modal" data-target="#InsertMemberModalCenter">新增人員</button>--}}
                        </div>
                    </div>
                    {{-- 查看假單彈出視窗 --}}
                    <div class="modal fade" id="CheckLeave" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">確認請假資料</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                    <div class="modal-body row">
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="name" >姓名</label>
                                                <div class="col-sm-6">
                                                    <input id='name' name="name" style="text-align: center"  type="text" class="form-control" readonly >
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="category" >假別</label>
                                                <div class="col-sm-6">
                                                    <input id='category' name="category" style="text-align: center"  type="text" class="form-control" readonly >
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="reason" >原因</label>
                                                <div class="col-sm-6">
                                                    <input id='reason' name="reason" style="text-align: center"  type="text" class="form-control" readonly >
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="start" >開始時間</label>
                                                <div class="col-sm-6">
                                                    <input id='start' name="start" style="text-align: center"  type="text" class="form-control" readonly >
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="end" >結束時間</label>
                                                <div class="col-sm-6">
                                                    <input id='end' name="end" style="text-align: center"  type="text" class="form-control" readonly >
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="leave_time" >請假時長</label>
                                                <div class="col-sm-6">
                                                    <input id='leave_time' name="leave_time" style="text-align: center"  type="text" class="form-control" readonly >
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="leave_created" >申請日期</label>
                                                <div class="col-sm-6">
                                                    <input id='leave_created' name="leave_created" style="text-align: center"  type="text" class="form-control" readonly >
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">確定</button>
                                    </div>
                            </div>
                        </div>
                    </div>


                    {{-- 不同意彈出視窗 --}}
                    <div class="modal fade" id="DisagreeLeave" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">確認請假資料</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <form action="{{ route("disagree_leave") }}" method="POST" enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    <div class="modal-body row">
                                        <div class="col-sm-12">
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="name" >姓名</label>
                                                <div class="col-sm-6">
                                                    <input id='d_name' name="name" style="text-align: center"  type="text" class="form-control" readonly >
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="category" >假別</label>
                                                <div class="col-sm-6">
                                                    <input id='d_category' name="category" style="text-align: center"  type="text" class="form-control" readonly >
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="reason" >原因</label>
                                                <div class="col-sm-6">
                                                    <input id='d_reason' name="reason" style="text-align: center"  type="text" class="form-control" readonly >
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="start" >開始時間</label>
                                                <div class="col-sm-6">
                                                    <input id='d_start' name="start" style="text-align: center"  type="text" class="form-control" readonly >
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="end" >結束時間</label>
                                                <div class="col-sm-6">
                                                    <input id='d_end' name="end" style="text-align: center"  type="text" class="form-control" readonly >
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-3 col-form-label" for="leave_time" >請假時長</label>
                                                <div class="col-sm-6">
                                                    <input id='d_leave_time' name="leave_time" style="text-align: center"  type="text" class="form-control" readonly >
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label style="text-align: right;" class="col-sm-5 col-form-label" for="disagree" >請填寫不同意假單原因</label>
                                                <div class="col-sm-6">
                                                    <input id='no' name="no" style="text-align: center"  type="hidden">
                                                    <input id='disagree' name="disagree" style="text-align: center"  type="text" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                                        <button type="submit" class="btn btn-primary">提交</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    {{--現有人員資訊區--}}
                    <table class="table table-striped table-bordered table-hover fixed-height" id="tableL01"></table>
                </div>

            </div>
        </div>
    </div>


    {{--selectize
    <script>
        $(document).ready(function () {
$('#example').selectize({
});
        });
    </script>--}}





    {{--跳出錯誤訊息    --}}
        @if(isset($error_msg))
            <script>
                alert('{{ $error_msg }}');
            </script>
    @endif

    {{--force on the camera by you choose--}}
    @if(isset($camera_info))
        <script>
            document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}"+"_btn").setAttribute("style","background-color:transparent;color: #2fa360;font-weight: bolder;border: none;");
            document.getElementById("{{ $camera_info['group'].$camera_info['name'] }}").setAttribute("style","color: #2fa360;font-weight: bolder;");
            document.getElementById("{{ $camera_info['group'] }}"+"collapse").classList.add("show");
        </script>
    @endif

{{--    boostrap tabel js--}}
    <script>
        // 載入人員資料
        @php
            if(isset($rowdata)){
                echo "var jdata=".json_encode($rowdata).";";
            }else{
                echo "var jadata=[];";
            }
        @endphp

        $('#tableL01').bootstrapTable('destroy');   //動態載入表格之前，先銷燬表格
        if({{$check}}=="1")
        {
            var tableColumns = [
                {field: 'leave_off_work_no', title: '姓名', sortable: false},
                {field: 'signing_status_1', title: '審核1', sortable: false},
                {field: 'signing_status_2', title: '審核2', sortable: false},
                {field: 'signing_status_3', title: '審核3', sortable: false},
                {field: 'signing_status_4', title: '審核4', sortable: false},
                {field: 'disagree', title: '審核不通過', sortable: false},
            ];
        }
        else
        {
            var tableColumns = [
                {field: 'leave_off_work_no',title: '姓名', sortable: false},
                {field: 'signing_status_1', title: '審核1', sortable: false},
                {field: 'signing_status_2', title: '審核2', sortable: false},
                {field: 'signing_status_3', title: '審核3', sortable: false},
                {field: 'disagree',title: '審核不通過', sortable: false},
            ];
        }

        $('#tableL01').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0.3*Math.max(document.documentElement.clientWidth, window.innerWidth || 0),
            height:0.3*Math.max(document.documentElement.clientHeight, window.innerHeight || 0),
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: false,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'day', // 預設排序
        });
        // 確認假單資訊資料處理
        function check(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            document.getElementById("name").value=jdata[jdata_index].name;
            document.getElementById("category").value=jdata[jdata_index].category;
            document.getElementById("reason").value=jdata[jdata_index].reason;
            document.getElementById("start").value=jdata[jdata_index].start;
            document.getElementById("end").value=jdata[jdata_index].end;
            document.getElementById("leave_time").value=jdata[jdata_index].leave_time;
            document.getElementById("leave_created").value=jdata[jdata_index].created;
        }
        //不同意資料處理
        function disagree(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            document.getElementById("d_name").value=jdata[jdata_index].name;
            document.getElementById("d_category").value=jdata[jdata_index].category;
            document.getElementById("d_reason").value=jdata[jdata_index].reason;
            document.getElementById("d_start").value=jdata[jdata_index].start;
            document.getElementById("d_end").value=jdata[jdata_index].end;
            document.getElementById("d_leave_time").value=jdata[jdata_index].leave_time;
            document.getElementById("no").value=jdata[jdata_index].no;
        }
        // html string to element
        function htmlToElement(html) {
            var template = document.createElement('template');
            html = html.trim(); // Never return a text node of whitespace as the result
            template.innerHTML = html;
            return template.content.firstChild;
        }
    </script>
    <script>
        {{--    取得已選取目標--}}
        function getIdSelections() {
            return $.map($('#tableL01').bootstrapTable('getSelections'), function (row) {
                return row.no
            })
        }
        function getLeaveSelections() {
            return $.map($('#tableL01').bootstrapTable('getSelections'), function (row) {
                return row.leave
            })
        }
        function getDepartSelections() {
            return $.map($('#tableL01').bootstrapTable('getSelections'), function (row) {
                return row.depart_leave_unit_department
            })
        }
        {{--審核--}}
        function post_check_status_1(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            var idselections=jdata[jdata_index].no;
            let leave=jdata[jdata_index].leave;
            let depart=jdata[jdata_index].depart_leave_unit_department;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("update_supervisorcheckleave") }}");
            var idselectionsField = document.createElement("input");
            idselectionsField.setAttribute("type", "hidden");
            idselectionsField.setAttribute("name", "no");
            idselectionsField.setAttribute("value",idselections);
            form.appendChild(idselectionsField);
            var leaveselectionsField = document.createElement("input");
            leaveselectionsField.setAttribute("type", "hidden");
            leaveselectionsField.setAttribute("name", "leave");
            leaveselectionsField.setAttribute("value",leave);
            form.appendChild(leaveselectionsField);
            var departselectionsField = document.createElement("input");
            departselectionsField.setAttribute("type", "hidden");
            departselectionsField.setAttribute("name", "depart");
            departselectionsField.setAttribute("value",depart);
            form.appendChild(departselectionsField);
            var status1selectionsField = document.createElement("input");
            status1selectionsField.setAttribute("type", "hidden");
            status1selectionsField.setAttribute("name", "status1");
            status1selectionsField.setAttribute("value","1");
            form.appendChild(status1selectionsField);
            var status2selectionsField = document.createElement("input");
            status2selectionsField.setAttribute("type", "hidden");
            status2selectionsField.setAttribute("name", "status2");
            status2selectionsField.setAttribute("value","0");
            form.appendChild(status2selectionsField);
            var status3selectionsField = document.createElement("input");
            status3selectionsField.setAttribute("type", "hidden");
            status3selectionsField.setAttribute("name", "status3");
            status3selectionsField.setAttribute("value","0");
            form.appendChild(status3selectionsField);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
        function post_check_status_2(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            var idselections=jdata[jdata_index].no;
            let leave=jdata[jdata_index].leave;
            let depart=jdata[jdata_index].depart_leave_unit_department;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("update_supervisorcheckleave") }}");
            var idselectionsField = document.createElement("input");
            idselectionsField.setAttribute("type", "hidden");
            idselectionsField.setAttribute("name", "no");
            idselectionsField.setAttribute("value",idselections);
            form.appendChild(idselectionsField);
            var leaveselectionsField = document.createElement("input");
            leaveselectionsField.setAttribute("type", "hidden");
            leaveselectionsField.setAttribute("name", "leave");
            leaveselectionsField.setAttribute("value",leave);
            form.appendChild(leaveselectionsField);
            var departselectionsField = document.createElement("input");
            departselectionsField.setAttribute("type", "hidden");
            departselectionsField.setAttribute("name", "depart");
            departselectionsField.setAttribute("value",depart);
            form.appendChild(departselectionsField);
            var status1selectionsField = document.createElement("input");
            status1selectionsField.setAttribute("type", "hidden");
            status1selectionsField.setAttribute("name", "status1");
            status1selectionsField.setAttribute("value","1");
            form.appendChild(status1selectionsField);
            var status2selectionsField = document.createElement("input");
            status2selectionsField.setAttribute("type", "hidden");
            status2selectionsField.setAttribute("name", "status2");
            status2selectionsField.setAttribute("value","1");
            form.appendChild(status2selectionsField);
            var status3selectionsField = document.createElement("input");
            status3selectionsField.setAttribute("type", "hidden");
            status3selectionsField.setAttribute("name", "status3");
            status3selectionsField.setAttribute("value","0");
            form.appendChild(status3selectionsField);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
        function post_check_status_3(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            var idselections=jdata[jdata_index].no;
            let leave=jdata[jdata_index].leave;
            let depart=jdata[jdata_index].depart_leave_unit_department;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("update_supervisorcheckleave") }}");
            var idselectionsField = document.createElement("input");
            idselectionsField.setAttribute("type", "hidden");
            idselectionsField.setAttribute("name", "no");
            idselectionsField.setAttribute("value",idselections);
            form.appendChild(idselectionsField);
            var leaveselectionsField = document.createElement("input");
            leaveselectionsField.setAttribute("type", "hidden");
            leaveselectionsField.setAttribute("name", "leave");
            leaveselectionsField.setAttribute("value",leave);
            form.appendChild(leaveselectionsField);
            var departselectionsField = document.createElement("input");
            departselectionsField.setAttribute("type", "hidden");
            departselectionsField.setAttribute("name", "depart");
            departselectionsField.setAttribute("value",depart);
            form.appendChild(departselectionsField);
            var status1selectionsField = document.createElement("input");
            status1selectionsField.setAttribute("type", "hidden");
            status1selectionsField.setAttribute("name", "status1");
            status1selectionsField.setAttribute("value","1");
            form.appendChild(status1selectionsField);
            var status2selectionsField = document.createElement("input");
            status2selectionsField.setAttribute("type", "hidden");
            status2selectionsField.setAttribute("name", "status2");
            status2selectionsField.setAttribute("value","1");
            form.appendChild(status2selectionsField);
            var status3selectionsField = document.createElement("input");
            status3selectionsField.setAttribute("type", "hidden");
            status3selectionsField.setAttribute("name", "status3");
            status3selectionsField.setAttribute("value","1");
            form.appendChild(status3selectionsField);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
        function post_check_status_4(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            var idselections=jdata[jdata_index].no;
            let leave=jdata[jdata_index].leave;
            let depart=jdata[jdata_index].depart_leave_unit_department;
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("update_supervisorcheckleave") }}");
            var idselectionsField = document.createElement("input");
            idselectionsField.setAttribute("type", "hidden");
            idselectionsField.setAttribute("name", "no");
            idselectionsField.setAttribute("value",idselections);
            form.appendChild(idselectionsField);
            var leaveselectionsField = document.createElement("input");
            leaveselectionsField.setAttribute("type", "hidden");
            leaveselectionsField.setAttribute("name", "leave");
            leaveselectionsField.setAttribute("value",leave);
            form.appendChild(leaveselectionsField);
            var departselectionsField = document.createElement("input");
            departselectionsField.setAttribute("type", "hidden");
            departselectionsField.setAttribute("name", "depart");
            departselectionsField.setAttribute("value",depart);
            form.appendChild(departselectionsField);
            var status1selectionsField = document.createElement("input");
            status1selectionsField.setAttribute("type", "hidden");
            status1selectionsField.setAttribute("name", "status1");
            status1selectionsField.setAttribute("value","1");
            form.appendChild(status1selectionsField);
            var status2selectionsField = document.createElement("input");
            status2selectionsField.setAttribute("type", "hidden");
            status2selectionsField.setAttribute("name", "status2");
            status2selectionsField.setAttribute("value","1");
            form.appendChild(status2selectionsField);
            var status3selectionsField = document.createElement("input");
            status3selectionsField.setAttribute("type", "hidden");
            status3selectionsField.setAttribute("name", "status3");
            status3selectionsField.setAttribute("value","1");
            form.appendChild(status3selectionsField);
            var status4selectionsField = document.createElement("input");
            status4selectionsField.setAttribute("type", "hidden");
            status4selectionsField.setAttribute("name", "status4");
            status4selectionsField.setAttribute("value","1");
            form.appendChild(status4selectionsField);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
        {{--    人臉圖片預覽--}}
        var inputface=document.getElementById("face-img-input");
        var previewface=document.getElementById("face-img-preview");
        inputface.addEventListener('change',function () {
            var file =this.files[0];
            var reader=new FileReader();
            // 可接受的附檔名
            var validExts = new Array(".jpg");
            var fileExt = file.name.substring(file.name.lastIndexOf('.'));
            reader.addEventListener('load',function () {
                if (validExts.indexOf(fileExt) < 0) {
                    alert("檔案類型錯誤，可接受的副檔名有：" + validExts.toString());
                    return false;
                }else{
                    previewface.src=reader.result;
                }
            },false);
            reader.readAsDataURL(file);
        },false);
        var modifyface=document.getElementById("modify-face-img-input");
        var modifypreviewface=document.getElementById("modify-face-img-preview");
        modifyface.addEventListener('change',function () {
            var file =this.files[0];
            var reader=new FileReader();
            // 可接受的附檔名
            var validExts = new Array(".jpg");
            var fileExt = file.name.substring(file.name.lastIndexOf('.'));
            reader.addEventListener('load',function () {
                if (validExts.indexOf(fileExt) < 0) {
                    alert("檔案類型錯誤，可接受的副檔名有：" + validExts.toString());
                    return false;
                }else{
                    modifypreviewface.src=reader.result;
                }
            },false);
            reader.readAsDataURL(file);
        },false);
        // 下拉選單預設值回調
        $('#inputGroupSelect04').val("{{ old("search_type","default") }}");
        // 有效期間選擇響應
        function selectExpiryDateonchange(x) {
            let elemet_selted=document.getElementById(x).value;
            // console.log(elemet_selted);
            switch (elemet_selted) {
                case '1':
                    $("#start_time").removeAttr("required");
                    $("#end_time").removeAttr("required");
                    $("#modify-start-time").removeAttr("required");
                    $("#modify-end-time").removeAttr("required");
                    break;
                case '2':
                    $("#start_time").attr("required","true");
                    $("#end_time").attr("required","true");
                    $("#modify-start-time").attr("required","true");
                    $("#modify-end-time").attr("required","true");
                    break;
                default:
                    break;
            }
        }
    </script>
@endsection
